/******************************************************************************\

Module Name:    LVideoIn.c

Description:    LVideoIn sample implementation file.

References:     LVideoIn.doc Revision 1.2.
                Matrox Liberatus specifications

    Copyright (c) 2014, Matrox Graphics Inc.
    All Rights Reserved.

BSD 2-Clause License

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

\******************************************************************************/

#include "Liberatus.h"
#include "LBuffer.h"
#include "LVideoIn.h"

/********************************************************************\

Function:       main

Description:    LVideoIn sample entry point.

Parameters:     None.

Return Value:   0 on success, -1 otherwise.

Comments:       - Detect video signal, prepare and start the capture,
                  retrieve 100 fields that release the resources.

\********************************************************************/
int main()
{
    LDevice_Handle  hDevice         = MNULL;
    LBuffer_Handle  hCapturedBuffer = MNULL;
    LVideoIn_Handle hVideoIn        = MNULL;
    MBOOL32         bSourceValid    = MFALSE;
    MUINT32         uiWidth         = 0;
    MUINT32         uiHeight        = 0;
    LPixelFormat    ePixelFormat    = LPixelFormat_INVALID;
    MUINT64         uiFieldCounter  = 0;
    MUINT64         uiTickRefCounter= 0;
    MBOOL32         bIsTopField     = 0;
    MUINT32         uiIndex         = 0;

    Liberatus_Load();

    /* Get the handle of the primary device.                        */
    hDevice = Liberatus_GetDevice(0);

    /* Get the handle of the primary video input in exclusive mode  */
    LVideoIn_GetHandle(hDevice,
                       0,
                       LAccessMode_READWRITE_EXCLUSIVE,
                       &hVideoIn);

    /* Detect the video source                                      */
    LVideoIn_DetectSource(hVideoIn,
                          &bSourceValid,
                          MNULL,
                          &uiWidth,
                          &uiHeight);

    if (bSourceValid)
    {

        /* Get the first pixel format supported                     */
        LVideoIn_EnumSupportedPixelFormat(hVideoIn,
                                          0,
                                          &ePixelFormat);

        /* Internally create 10 video buffers for the capture       */
        LVideoIn_CreateBuffers(hVideoIn,
                               uiWidth,
                               uiHeight,
                               ePixelFormat,
                               10);

        /* Start grabbing the video signal                          */
        LVideoIn_StartCapture(hVideoIn);

        for (uiIndex=0; uiIndex < 100; uiIndex++)
        {

            /* Wait until a new picture is ready (200ms timeout)    */
            LVideoIn_GetNextBuffer( hVideoIn,
                                    MTRUE,
                                    200,
                                    &hCapturedBuffer,
                                    &uiFieldCounter,
                                    &uiTickRefCounter,
                                    &bIsTopField);

            /* ... Here do something with hCapturedBuffer buffers   */

            /* Return the buffer to the video capture engine        */
            LVideoIn_ReleaseBuffer( hVideoIn,
                                    hCapturedBuffer);

        }

        /* Stop and release resources                              */
        LVideoIn_StopCapture(hVideoIn);

        LVideoIn_DestroyBuffers(hVideoIn);

    }

    /* Release resources                                            */
    LVideoIn_ReleaseHandle(hVideoIn);

    Liberatus_UnLoad();

    return 0;
}
